# Algorithme de recherche du minimum

## Spécification du problème

L'algorithme doit renvoyer la plus petite valeur du tableau. Si le tableau 
est vide, la fonction ne doit rien renvoyer.

## Solution n°1

Avec en précondition un tableau trié par ordre croissant, il suffit de renvoyer 
la première valeur du tableau. La complexité ne dépend pas du nombre de valeurs, elle est en "O(1)".

```python
from typing import List
def minimum(valeurs : List[float]) -> float:
	""" renvoie la plus petite valeur du tableau
	@param valeurs les valeurs dont on cherche la plus petite
	précondition: valeurs est trié par ordre croissant
	>>> minimum([])
	None
	>>> minimum([1, 2, 3, 4, 5])
	1
	"""
	if len(valeurs) == 0:
		val = None
	else:
		val = valeurs[0]
	return val
```

## Solution n°2

Sans précondition sur le fait que le tableau soit trié ou non, il faut parcourir 
tout le tableau pour trouver la plus petite valeur. S'il y a "n" valeurs, on dénombre 
"n" comparaisons. La complexité est en "O(n)".

```python
from typing import List

def minimum(valeurs : List[float]) -> int:
	""" renvoie la plus petite valeur du tableau
	@param valeurs les valeurs dont on cherche la plus petite
	précondition: /
	>>> minimum([])
	None
	>>> minimum([2, 1, 5, 3, 4])
	1
	"""
	if len(valeurs) == 0:
		val = None
	else:
		val = valeurs[0]
		for i in range(1, len(valeurs)):
			if valeurs[i] < val:
				val = valeurs[i]
	return val
```

### Preuve de correction partielle

Invariant : à chaque itérative, val contient la plus petite valeur du tableau 
entre les indices 0 et i.


### Preuve de terminaison

Une itérative pour se termine par définition.
